function [x_last, f_vec, g_vec, f_par, f_orth, angle_vec, x_hist] = PenaltyGD_new(f, grad_f, g, grad_g, param, x0, lambda_penalty)
    stepsize = param.stepsize /(lambda_penalty);
    max_iter = param.max_iter;

    x = x0;
    f_vec = zeros(max_iter, 1);
    g_vec = zeros(max_iter, 1);
    f_par = zeros(max_iter, 1);
    f_orth = zeros(max_iter, 1);
    angle_vec = zeros(max_iter, 1);
    x_hist = zeros(max_iter, length(x0));

    for k = 1:max_iter
        grad_g_k = grad_g(x);
        grad_f_k = grad_f(x);

        f_vec(k) = f(x);
        g_vec(k) = norm(grad_g_k)^2;
        f_par(k) = (grad_f_k' * grad_g_k / norm(grad_g_k))^2;
        f_orth(k) = norm(grad_f_k)^2 - f_par(k);
        angle_vec(k) = abs((grad_f_k' * grad_g_k) / (norm(grad_f_k) * norm(grad_g_k)));
        x_hist(k,:) = x';

        x = x - stepsize * (grad_f_k + lambda_penalty * grad_g_k);
    end

    x_last = x;
end
